@extends('dashboard.layouts.app')
@push('headScripts')

@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Users & Roles') }} /</span> <span class="text-muted fw-light">{{ __('Roles') }} /</span> {{ (isset($role))?__('Edit :type',['type'=>$role->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ (isset($role))?__('Edit :type',['type'=>$role->name]):__('Create') }}</h5>
                    <div class="card-body">
                        <form method="POST" action="{{ isset($role)?route('roles.update',['role'=>$role]):route('roles.store') }}">
                            @if(isset($role))
                                @method('PUT')
                            @endif
                            @csrf
                            <div class="form-group mb-3">
                                <label class="form-label">{{ __('Name') }}</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror border-left-0" name="name" id="name" value="{{ isset($role)?$role->name:old('name') }}" placeholder="{{ __('Enter :value',['value'=>__('Role Name')]) }}">
                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                @enderror
                            </div>
                            @include('dashboard.include.permissions_table')
                            <div class="text-center">
                                <button type="submit" class="btn btn-danger px-5">{{ __('Save') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script src="{{ asset('js/permissions_table.js') }}"></script>
@endpush
