@extends('dashboard.layouts.app')
@push('headScripts')
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" type="text/css">@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Users & Roles') }} /</span> {{ __('Users') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ __('Users') }}</h5>
                        <div class="m-4 mb-0 mt-0">
                            @if(PerUser('users.export'))
                                <div class="btn-group float-end ms-1 me-1" role="group">
                                    <button id="exportSelectedUsers" type="button" class="btn btn-primary dropdown-toggle export-selected" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fadeIn animated bx bx-export"></i>
                                        {!! __('Export Selected :type',['type'=>__('User')]) !!}
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="exportSelectedUsers">
                                        <a class="dropdown-item export-type" data-type="csv">{{ __('CSV') }}</a>
                                        <a class="dropdown-item export-type" data-type="excel">{{ __('Excel') }}</a>
                                        <a class="dropdown-item export-type" data-type="pdf">{{ __('PDF') }}</a>
                                    </div>
                                    <form action="{{ route('users.export') }}" method="POST" id="exportData" class="d-inline-block">
                                        <input type="hidden" id="exportIDS" name="IDS">
                                        <input type="hidden" name="export_type" value="excel">
                                        @csrf
                                        {{--                            <button class="btn btn-info export-selected"><i class="fadeIn animated bx bx-export"></i> {!! __('Export Selected :type',['type'=>__('User')]) !!}</button>--}}
                                    </form>
                                </div>
                                <div class="btn-group float-end ms-1 me-1" role="group">
                                    <button id="exportUsers" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fadeIn animated bx bx-export"></i>
                                        {{ __('Export') }}
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-left" aria-labelledby="exportUsers">
                                        <a class="dropdown-item export-type" data-type="csv">{{ __('CSV') }}</a>
                                        <a class="dropdown-item export-type" data-type="excel">{{ __('Excel') }}</a>
                                        <a class="dropdown-item export-type" data-type="pdf">{{ __('PDF') }}</a>
                                    </div>
                                    <form action="{{ route('users.export') }}" method="POST" class="d-inline-block">
                                        <input type="hidden" name="export_type" value="excel">
                                        @csrf
                                        {{--                            <button class="btn btn-info "><i class="fadeIn animated bx bx-export"></i> {{ __('Export') }}</button>--}}
                                    </form>
                                </div>


                            @endif
                            @if(PerUser('users.destroy'))
                                <a href="#" class="btn btn-danger delete-selected float-end ms-1 me-1"><i class="fadeIn animated bx bx-trash-alt"></i> {!! __('Delete Selected :type',['type'=>__('User')]) !!}</a>
                            @endif
                            @if(PerUser('users.create'))
                                <a href="{{ route('users.create') }}" class="btn btn-primary float-end ms-1 me-1"><i class="fadeIn animated bx bx-message-square-add"></i> {{ __('Create :type',['type'=>__('User')]) }}</a>
                            @endif
                        </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            {{ $dataTable->table(['class' => 'table table-bordered table-striped mb-0']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script src="{{ asset('vendor/sweetalert/sweetalert.all.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    <script>
        $(document).on('click','.export-type',function(e){
            e.preventDefault();
            let form=$(this).parent().parent().find('form')
            form.find('[name="export_type"]').val($(this).attr('data-type'));
            form.submit();
        })
        function checkMultiDeleteButton(){
           if($(".user-checkbox").is(':checked')){
               $(".delete-selected").removeClass('disabled');
               $(".export-selected,.export-types").removeClass('disabled');
           }else{
               $(".delete-selected").addClass('disabled')
               $(".export-selected,.export-types").addClass('disabled')

           }
        }
        checkMultiDeleteButton();
        $(document).on('click','.delete-selected',function(){
            let IDS=[];
            $('.user-checkbox:checked').each(function(){
                IDS.push($(this).val());
            })
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('users.multi_destroy') }}",
                        data:{IDS},
                        success: function (msg) {
                            window.LaravelDataTables["users"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                            $(".delete-selected").addClass('disabled').find('.selectedCount').text(0)
                        }
                    });

                }
            })
        })
        function addSelectedCount(){
            $(".selectedCount").text($(".user-checkbox:checked").length)
            let IDS=[];
            $('.user-checkbox:checked').each(function(){
                IDS.push($(this).val());
            })
            $("#exportIDS").val(IDS);
        }
        $(document).on('change','#selectAllCheckbox',function(){
            $('table#users tbody input[type="checkbox"].user-checkbox').prop('checked',$(this).is(':checked'))
            checkMultiDeleteButton();
            addSelectedCount()
        });
        $(document).on('change','.user-checkbox',function (){
            checkMultiDeleteButton();
            addSelectedCount()
        })
        @if(PerUser('users.destroy'))
        $(document).on('click','.delete-selected',function(){

        });
        $(document).on('click','.delete-this',function(e){
            e.preventDefault()
            let el=$(this);
            let url=el.attr('data-url')
            let id=el.attr('data-id')
            Swal.fire({
                title: '{{ __('Do you really want to delete this?') }}',
                showCancelButton: true,
                confirmButtonText: '{{ __('Yes') }}',
                cancelButtonText: '{{ __('No') }}',
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: url,
                        success: function (msg) {
                            window.LaravelDataTables["users"].draw();
                            Swal.fire(msg.message, '', msg.success?'success':'error')
                        }
                    });

                }
            })
        })
        @endif
    </script>
@endpush
