<?php

namespace App\Exports;

use App\Models\UsersKPI;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UserKPISExport implements WithMapping, WithHeadings,FromQuery
{

    public function query()
    {
        $user_kpis=UsersKPI::query();
        if(request('IDS')){
            $user_kpis=$user_kpis->whereIn('id',explode(',',request('IDS')));
        }
        return $user_kpis;
    }
    /**
    * @return \Illuminate\Support\Collection
    */

    public function map($user_kpi) : array {
        return [

            $user_kpi->title,
            $user_kpi->status,
            $user_kpi->created_at?$user_kpi->created_at->format('d M Y, h:i a'):'',

        ] ;
    }
    public function headings() : array {
        return [
            __('Title'),
            __('Status'),
            __('Created At')
        ] ;
    }
}
